--[[---------------------------------------------------------------------------
	Chocolatier Two Factory Status UI
	Copyright (c) 2006-2007 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

local self = gDialogTable.factory
local char = self.character[1]

-------------------------------------------------------------------------------

local function CloseDialog()
	gCurrentFactory = nil
	gDialogTable.factory = nil
	gSim.port:SetAmbient()
	CloseWindow()
end

-------------------------------------------------------------------------------
-- Support functions

local function ChangeConfigurationMessage()
	local config = GetString("factory_config", GetString(self.port.name), tostring(self.rate), GetString(self.product.name))
	gSim:Message(config)
end

local function UpdateConfiguration()
	SetLabel("product", GetString(self.product.name))
	SetBitmap("product_image", "item/"..self.product.name.."_big")
	SetLabel("rate", tostring(self.rate))
end

local function DoMinigame(oldProduct)
	-- Enough ingredients to manufacture the current recipe?
	local missing = {}
	for ing,count in pairs(self.product.recipe) do
		local item = LItem:ByName(ing)
		if item.inventory < count then table.insert(missing,item) end
	end
	
	if table.getn(missing) > 0 then
		DisplayDialog { "ui/factory_out.lua", factory=self, missing=missing, char=char }
		
		-- Not enough ingredients -- leave old configuration
		if oldProduct then self:SetConfiguration(oldProduct.name) end
	else
		local rate = DisplayDialog { "ui/factory_minigame.lua", factory=self, char=char }
		self.port:SetAmbient()
		if type(rate) == "number" then
			self:SetConfiguration(self.product.name, rate)
			ChangeConfigurationMessage()
			gSim:Tick()
			CloseDialog()
		else
			-- Cancelled -- leave old configuration
			if oldProduct then self:SetConfiguration(oldProduct.name) end
		end
	end
end

local function Reconfigure()
	local restoredialog = true
	EnableWindow("factory_status", false)
	
	local recipe = DisplayDialog { "ui/recipebook.lua", factory=self }
	if recipe then
		if not self.machines[recipe.type.name] then
			local price = recipe.type.price or 10000
			if price > gSim.money then
				local s = GetString("machinery_buy_toomuch", GetString(recipe.type.name), bsgDollars(price))
				DisplayDialog { "ui/chartalk.lua", char=char, fullbody=s, ok="ok" }
			else
				local s = GetString("machinery_buy", GetString(recipe.type.name), bsgDollars(price))
				local yn = DisplayDialog { "ui/chartalk.lua", char=char, fullbody=s, yes="yes", no="no" }
				if yn == "yes" then
					self.machines[recipe.type.name] = true
					gSim:AdjustMoney(-price)
					s = GetString("machinery_purchased", GetString(recipe.type.name), GetString(self.name))
					gSim:Message(s)
				end
			end
		end
	
		if self.machines[recipe.type.name] then
			local oldProduct = self.product
			self:SetConfiguration(recipe.name)
			if self.rate == 0 then
				DoMinigame(oldProduct)
				if self.product == recipe and self.rate > 0 then
					restoredialog = false
				end
			else
				ChangeConfigurationMessage()
			end
			LFactory:ProjectProduction()
			UpdateLedgerContents("factories")
		end
	end
	
	if restoredialog then
		EnableWindow("factory_status", true)
		UpdateConfiguration()
		Pause(5)
	end
end

-------------------------------------------------------------------------------

local w=600
local h=280
local yMachines = h-65

local machines = {}
local x = 0
local n = 0
local dx = bsgFloor((w - 200) / 6)
for i,type in ipairs(LProductType._ByIndex) do
	if self.machines[type.name] then
		table.insert(machines, Text { x=x,y=yMachines-20, w=dx,h=20, label=LabelString(type.name) })
		table.insert(machines, Bitmap { image="image/machine_"..type.name, x=x, y=yMachines, scale=dx/250 })
	else
		table.insert(machines, Text { x=x,y=yMachines-20, w=dx,h=20, label=LabelString(type.name), font=standardGrayFont })
		table.insert(machines, Bitmap { image="image/machine_"..type.name.."_linestyle", x=x, y=yMachines, scale=dx/250 })
	end
	x = x + dx
end

-------------------------------------------------------------------------------

MakeDialog
{
	name="factory_status",
	DialogLedger(),
	Frame
	{
		x=100+ui.xOffset,y=50+ui.yOffset,w=w,h=h, color=DialogColor,

		AppendStyle { font=dialogFont },
		Text { x=0,y=5,w=205,h=20, label="now_making" },
		
		Rollover { x=70,y=20, fit=true,
			contents="gCurrentFactory.product:ProductRollover()",
			Bitmap { image="item/"..self.product.name.."_big", name="product_image" },
		},
		
--		Bitmap { x=70,y=20, image="item/"..self.product.name.."_big", name="product_image" },
		Text { x=0,y=84,w=205,h=40, name="product", label=LabelString(self.product.name), flags=kHAlignCenter+kVAlignCenter },
		TextButton { x=(205-ui.devButtonW)/2,y=130, label="reconfigure", command=Reconfigure, },
		
--		Text { x=205,y=5,w=205,h=20, label="current_output" },
--		Text { x=205,y=5,w=205,h=130, name="rate", label=self.rate, font=productionFont, flags=kHAlignCenter+kVAlignTop },
		Text { x=205,y=23,w=205,h=20, label="current_output" },
		Text { x=205,y=23,w=205,h=100, name="rate", label=self.rate, font=productionFont, flags=kHAlignCenter+kVAlignTop },
		Text { x=205,y=104,w=205,h=20, label="cases_per" },
		TextButton { x=205+(205-ui.devButtonW)/2,y=130, label="minigame", command=DoMinigame, },

		Text { x=5,y=yMachines-40, w=kMax,h=20, label="machines_onhand", flags=kVAlignCenter+kHAlignLeft },
		Group(machines),

		SetStyle(standardStyle),
		
--		TextButton { x=418,y=230, name="ok", command=CloseDialog, label="ok" },
		TextButton { x=418,y=230, name="help", label="help", graphics=SmallButtonGraphics, command=function() HelpDialog(6) end },
		TextButton { x=418+62,y=230, name="ok", label="close", command=CloseDialog, graphics=MediumButtonGraphics },
	},
	BuildingBanner(self),
	char:Visual(ui.screenWidth-100-ui.charW+ui.xOffset, ui.yOffset, charNameFontDark),
}
